//
//  Playing_Audio_over_Other_Active_SoundsViewController.m
//  Playing Audio over Other Active Sounds
//
//  Created by Vandad Nahavandipoor on 16/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Playing_Audio_over_Other_Active_SoundsViewController.h"

@implementation Playing_Audio_over_Other_Active_SoundsViewController

@synthesize audioPlayer;

- (void)audioPlayerBeginInterruption:(AVAudioPlayer *)player{
  /* Sesja audio została przerwana. W tym miejscu odtwarzacz wstrzyma odtwarzanie treści audio. */
}

- (void)audioPlayerEndInterruption:(AVAudioPlayer *)player 
                         withFlags:(NSUInteger)flags{
  if (flags == AVAudioSessionInterruptionFlags_ShouldResume){
    [player play];
  }  
}

- (void)audioPlayerDidFinishPlaying:(AVAudioPlayer *)player 
                       successfully:(BOOL)flag{
  
  if (flag){
    NSLog(@"Udało się poprawnie zatrzymać działanie odtwarzacza treści audio.");
  } else {
    NSLog(@"Nie udało się poprawnie zatrzymać działania odtwarzacza treści audio.");
  }
  
  if ([player isEqual:self.audioPlayer]){
    self.audioPlayer = nil;
  } else {
    /* To nie jest nasz odtwarzacz treści audio. */
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  NSError *audioSessionError = nil;
  AVAudioSession *audioSession = [AVAudioSession sharedInstance];
  if ([audioSession setCategory:AVAudioSessionCategoryAmbient
                          error:&audioSessionError]){
    NSLog(@"Udało się ustawić sesję audio.");
  } else {
    NSLog(@"Nie udało się ustawić sesji audio");
  }
  
  dispatch_queue_t dispatchQueue = 
    dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
  
  dispatch_async(dispatchQueue, ^(void) {
    NSBundle *mainBundle = [NSBundle mainBundle];
    
    NSString *filePath = [mainBundle pathForResource:@"MySong"
                                              ofType:@"mp3"];
    
    NSData *fileData = [NSData dataWithContentsOfFile:filePath];
    
    NSError *audioPlayerError = nil;
    
    self.audioPlayer = [[AVAudioPlayer alloc] initWithData:fileData 
                                                     error:&audioPlayerError];
    
    if (self.audioPlayer != nil){
      
      self.audioPlayer.delegate = self;
      
      if ([self.audioPlayer prepareToPlay] &&
          [self.audioPlayer play]){
        NSLog(@"Udało się rozpocząć odtwarzanie..");
        
      } else {
        NSLog(@"Nie udało się rozpocząć odtwarzania pliku audio.");
        self.audioPlayer = nil;
      }
      
    } else {
      NSLog(@"Nie udało się utworzyć odtwarzacza treści audio.");
    }
  });

}

- (void) viewDidUnload{
  [super viewDidUnload];
  
  if ([self.audioPlayer isPlaying]){
    [self.audioPlayer stop];
  }    
  self.audioPlayer = nil;
  
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
